export declare const cli: import("meow").Result<{
    init: {
        type: "boolean";
    };
    format: {
        type: "string";
        default: string;
    };
    output: {
        type: "string";
    };
    secretlintrc: {
        type: "string";
    };
    secretlintrcJSON: {
        type: "string";
    };
    secretlintignore: {
        type: "string";
        default: string;
    };
    /**
     * CLI enable ANSI-color of output by default
     */
    color: {
        type: "boolean";
        default: true;
    };
    /**
     * CLI enable terminalLink by default.
     * Some formatter will output that includes clickable clink
     * https://gist.github.com/egmontkob/eb114294efbcd5adb1944c9f3cb5feda
     */
    terminalLink: {
        type: "boolean";
        default: true;
    };
    maskSecrets: {
        type: "boolean";
        default: false;
    };
    profile: {
        type: "boolean";
    };
    locale: {
        type: "string";
    };
    cwd: {
        type: "string";
        default: string;
    };
    debug: {
        type: "boolean";
        default: false;
    };
}>;
export declare const run: (input?: string[], flags?: {
    init: boolean | undefined;
    format: string;
    output: string | undefined;
    secretlintrc: string | undefined;
    secretlintrcJSON: string | undefined;
    secretlintignore: string;
    color: boolean;
    terminalLink: boolean;
    maskSecrets: boolean;
    profile: boolean | undefined;
    locale: string | undefined;
    cwd: string;
    debug: boolean;
} & Record<string, unknown>) => Promise<{
    exitStatus: number;
    stdout: string | null;
    stderr: Error | null;
}>;
//# sourceMappingURL=cli.d.ts.map